// selectpo.cpp : implementation file
//

#include "stdlib.h"

#include "stdafx.h"
#include "comtest.h"
#include "resource.h"
#include "selectpo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectPortBox dialog

CSelectPortBox::CSelectPortBox(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectPortBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectPortBox)
	m_SelectedPort = "";
	//}}AFX_DATA_INIT
}

void CSelectPortBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectPortBox)
	DDX_CBString(pDX, IDC_COMBO1, m_SelectedPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSelectPortBox, CDialog)
	//{{AFX_MSG_MAP(CSelectPortBox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectPortBox message handlers

BOOL CSelectPortBox::OnInitDialog()
{
	int nLoc;      
	int comnum;
	char* chbuf=new char[200];    
	char* ResultMsg=new char[200];
	
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	for (comnum=1; comnum<=9; comnum++) 
	{
		sprintf(chbuf, "COM%d:",comnum);
		int commhandle= OpenComm(chbuf,256,256);
		switch (commhandle)
		{
			case IE_BADID:
				ResultMsg= "NO  - Invalid ID";
				break;
			case IE_BAUDRATE:
				ResultMsg= "NO  - Baudrate unsupported";
				break;
			case IE_BYTESIZE:
				ResultMsg= "NO  - Byte size invalid";
				break;
			case IE_DEFAULT:
				ResultMsg= "NO  - default parameter invalid";
				break;
			case IE_HARDWARE:
				ResultMsg= "NO  - Hardware not available";
				break;
			case IE_MEMORY:
				ResultMsg= "NO  - Not enough queue memory";
				break;
			case IE_NOPEN:       
				ResultMsg= "NO  - Not open";
				break;
			case IE_OPEN:
				ResultMsg= "NO  - allready open";
				break;
			default:
				ResultMsg= "OK";
				CloseComm(commhandle);
				break;
    	}    
		sprintf(chbuf, "COM%d: %s",comnum,ResultMsg);
		SelectPortCombo().AddString(chbuf);	
	}   
	
	nLoc = SelectPortCombo().FindString(0, "COM1" /*m_SelectedPort*/);
	SelectPortCombo().SetCurSel(nLoc);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
