// selectco.cpp : implementation file
//

#include "stdafx.h"
#include "comtest.h"
#include "resource.h"
#include "selectco.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectCom dialog

CSelectCom::CSelectCom(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectCom::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectCom)
	m_SelectedComPort = 0;
	//}}AFX_DATA_INIT
}

void CSelectCom::DoDataExchange(CDataExchange* pDX)
{
	int comnum;
	for (comnum=1; comnum<=9; comnum++) 
	{
		SelectComButton(comnum).EnableWindow(TRUE);
	}   

	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectCom)
	DDX_Radio(pDX, IDC_COM1, m_SelectedComPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSelectCom, CDialog)
	//{{AFX_MSG_MAP(CSelectCom)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectCom message handlers

BOOL CSelectCom::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	int comnum;
	char* chbuf=new char[200];    
	char* ResultMsg=new char[200];

	for (comnum=1; comnum<=9; comnum++) 
	{
		sprintf(chbuf, "COM%d:",comnum);
		int commhandle= OpenComm(chbuf,256,256);     
		SelectComButton(comnum).SetCheck(0);
		SelectComButton(comnum).EnableWindow(FALSE);
		switch (commhandle)
		{
			case IE_BADID:
				ResultMsg= "NO  - Invalid ID";
				break;
			case IE_BAUDRATE:
				ResultMsg= "NO  - Baudrate unsupported";
				break;
			case IE_BYTESIZE:
				ResultMsg= "NO  - Byte size invalid";
				break;
			case IE_DEFAULT:
				ResultMsg= "NO  - default parameter invalid";
				break;
			case IE_HARDWARE:
				ResultMsg= "NO  - Hardware not available";
				break;
			case IE_MEMORY:
				ResultMsg= "NO  - Not enough queue memory";
				break;
			case IE_NOPEN:       
				ResultMsg= "NO  - Not open";
				break;
			case IE_OPEN:
				ResultMsg= "NO  - allready open";
				break;
			default:
				ResultMsg= "OK";
				SelectComButton(comnum).EnableWindow(TRUE);
				CloseComm(commhandle);
				break;
    	}    
		sprintf(chbuf, "COM%d: %s",comnum,ResultMsg);

	}   
		                                    
	SelectComButton(m_SelectedComPort).SetCheck(1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
     