// comtest.h : Declares the class interfaces for the application.
//         comtest is a simple program which consists of a main window
//         and an "About" dialog which can be invoked by a menu choice.
//         It is intended to serve as a starting-point for new
//         applications.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#ifndef __comtest_H__
#define __comtest_H__                   

const MyTimerID=5552; // just an id for my own timer event

/////////////////////////////////////////////////////////////////////////////

// CMainWindow:
// See comtest.cpp for the code to the member functions and the message map.
//
class CMainWindow : public CFrameWnd
{
public:
	CMainWindow();

	//{{AFX_MSG( CMainWindow )
	afx_msg void OnPaint();
	afx_msg void OnAbout();
	afx_msg void OnFileExit();
	afx_msg void OnOptionsSelectport();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnOptionsSetParameters();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

	//Current Text Position	
	CPoint CurTextPos;
	int m_CurrentCommHandle;
	int m_CurrentComPort;
};

/////////////////////////////////////////////////////////////////////////////

// CTheApp:
// See comtest.cpp for the code to the InitInstance member function.
//
class CTheApp : public CWinApp
{
public:
	BOOL InitInstance();
};

/////////////////////////////////////////////////////////////////////////////

#endif // __comtest_H__

