// comtest.cpp : Defines the class behaviors for the application.
//           comtest is a simple program which consists of a main window
//           and an "About" dialog which can be invoked by a menu choice.
//           It is intended to serve as a starting-point for new
//           applications.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include "resource.h"

#include "comtest.h"
#include "selectpo.h"
#include "selectco.h"
#include "setcompa.h"


/////////////////////////////////////////////////////////////////////////////

// theApp:
// Just creating this application object runs the whole application.
//
CTheApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////

// CMainWindow constructor:
// Create the window with the appropriate style, size, menu, etc.
//
CMainWindow::CMainWindow()
{
	LoadAccelTable( "MainAccelTable" );
	Create( NULL, "VSComTest",
		WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
}

// OnPaint:
// This routine draws the string "comtest, Windows!" in the center of the
// client area.  It is called whenever Windows sends a WM_PAINT message.
// Note that creating a CPaintDC automatically does a BeginPaint and
// an EndPaint call is done when it is destroyed at the end of this
// function.  CPaintDC's constructor needs the window (this).
//
void CMainWindow::OnPaint()
{
	CString s = "comtest, Windows!";
	CPaintDC dc( this );
	CRect rect;

/*	GetClientRect( rect );
	dc.SetTextAlign( TA_BASELINE | TA_CENTER );
	dc.SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
	dc.SetBkMode(TRANSPARENT);
	dc.TextOut( ( rect.right / 2 ), ( rect.bottom / 2 ),
				s, s.GetLength() );*/
}

// OnAbout:
// This member function is called when a WM_COMMAND message with an
// IDM_ABOUT code is received by the CMainWindow class object.  The
// message map below is responsible for this routing.
//
// We create a ClDialog object using the "AboutBox" resource (see
// comtest.rc), and invoke it.
//
void CMainWindow::OnAbout()
{
	CDialog about( "AboutBox", this );
	about.DoModal();
}

// CMainWindow message map:
// Associate messages with member functions.
//
// It is implied that the ON_WM_PAINT macro expects a member function
// "void OnPaint()".
//
// It is implied that members connected with the ON_COMMAND macro
// receive no arguments and are void of return type, e.g., "void OnAbout()".
//
BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	//{{AFX_MSG_MAP( CMainWindow )
	ON_WM_PAINT()
	ON_COMMAND( IDM_ABOUT, OnAbout )
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_COMMAND(ID_OPTIONS_SELECTPORT, OnOptionsSelectport)
	ON_WM_CREATE()
	ON_WM_CHAR()
	ON_WM_TIMER()
	ON_COMMAND(ID_OPTIONS_SETCOMPARAMETERS, OnOptionsSetParameters)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTheApp

// InitInstance:
// When any CTheApp object is created, this member function is automatically
// called.  Any data may be set up at this point.
//
// Also, the main window of the application should be created and shown here.
// Return TRUE if the initialization is successful.
//
BOOL CTheApp::InitInstance()
{
	TRACE( "Init Instance\n" );

	SetDialogBkColor();     // hook gray dialogs (was default in MFC V1)

	m_pMainWnd = new CMainWindow();
	m_pMainWnd->ShowWindow( m_nCmdShow );
	m_pMainWnd->UpdateWindow();


	return TRUE;
}

void CMainWindow::OnFileExit()
{                        
	TRACE("OnFileExit\n");
	DestroyWindow();	
}

void CMainWindow::OnOptionsSelectport()
{                         
	TRACE("OnOptionsSelectport\n");
	if (m_CurrentComPort>0) 
	{
		CloseComm(m_CurrentCommHandle);
	} 
	CSelectCom selectcom( this );
	selectcom.m_SelectedComPort=m_CurrentComPort;
	selectcom.DoModal();           
	if (selectcom.m_SelectedComPort>=0) m_CurrentComPort=selectcom.m_SelectedComPort+1;
	if (m_CurrentComPort>0) 
	{
		DCB dcb;
		char* chbuf=new char[200];
		sprintf(chbuf, "COM%d:",m_CurrentComPort);
		m_CurrentCommHandle= OpenComm(chbuf,256,256);
		BuildCommDCB("COM1:9600,n,8,1", &dcb);
		SetCommState(&dcb);
	} 
	
}

int CMainWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	CurTextPos.x= 0;
	CurTextPos.y= 0;     
	
	m_CurrentComPort= 2;
	
	m_CurrentCommHandle= 0;
	
	SetTimer(MyTimerID,100,NULL);

	CDC* pdc =GetDC();
    
	pdc->SetTextAlign( TA_TOP | TA_LEFT );
	pdc->SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
	pdc->SetBkMode(OPAQUE);
	pdc->TextOut( CurTextPos.x, CurTextPos.y, "_", 1 );
	
	ReleaseDC(pdc);	
	
	return 0;
}

void CMainWindow::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default               
	CString F1Text ("abcdefghijklmnopqrstuvwxyz0123456789\n");
	
	F1Text+= F1Text;
//	F1Text+= F1Text;
//	F1Text+= F1Text;

	
	
	CFrameWnd ::OnChar(nChar, nRepCnt, nFlags);

	if (m_CurrentComPort>0) 
	{                      
		if (nChar== '0')
		{
			WriteComm(m_CurrentCommHandle, (const char*)F1Text, F1Text.GetLength() );
		} else
		{
			WriteComm(m_CurrentCommHandle, &nChar, 1);
		}
	} 

/*
	CDC* pdc =GetDC();
	CString s((char)(nChar & 0xFF) );
    
    s.OemToAnsi();
    
    if (nChar== VK_RETURN) 
    {
		pdc->SetTextAlign( TA_TOP | TA_LEFT );
		pdc->SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
		pdc->SetBkMode(OPAQUE);
		pdc->TextOut( CurTextPos.x, CurTextPos.y, "   ", 3 );
    	
    	CurTextPos.x= 0;
    	CurTextPos.y+= pdc->GetTextExtent(s, s.GetLength()).cy;
		pdc->TextOut( CurTextPos.x, CurTextPos.y, "_", 1 );
    } else
    {
		pdc->SetTextAlign( TA_TOP | TA_LEFT );
		pdc->SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
		pdc->SetBkMode(OPAQUE);
		pdc->TextOut( CurTextPos.x, CurTextPos.y, s, s.GetLength() );
		CurTextPos.x+= pdc->GetTextExtent(s, s.GetLength()).cx;
		pdc->TextOut( CurTextPos.x, CurTextPos.y, "_", 1 );
	}
	ReleaseDC(pdc);
*/	
}

void CMainWindow::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	
	CFrameWnd ::OnTimer(nIDEvent);      

    if (nIDEvent!=MyTimerID) return;
	
	char nChar;                           

	while (ReadComm(m_CurrentCommHandle, &nChar, 1)==1) 
	{

		CDC* pdc =GetDC();
		CString s((char)(nChar & 0xFF) );
    
    	s.OemToAnsi();
    
    	if (nChar== VK_RETURN) 
    	{
			pdc->SetTextAlign( TA_TOP | TA_LEFT );
			pdc->SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
			pdc->SetBkMode(OPAQUE);
			pdc->TextOut( CurTextPos.x, CurTextPos.y, "   ", 3 );
    	
    		CurTextPos.x= 0;
    		CurTextPos.y+= pdc->GetTextExtent(s, s.GetLength()).cy;
			pdc->TextOut( CurTextPos.x, CurTextPos.y, "_", 1 );
    	} else
    	{
			pdc->SetTextAlign( TA_TOP | TA_LEFT );
			pdc->SetTextColor( ::GetSysColor( COLOR_WINDOWTEXT ) );
			pdc->SetBkMode(OPAQUE);
			pdc->TextOut( CurTextPos.x, CurTextPos.y, s, s.GetLength() );
			CurTextPos.x+= pdc->GetTextExtent(s, s.GetLength()).cx;
			pdc->TextOut( CurTextPos.x, CurTextPos.y, "_", 1 );
		}
		ReleaseDC(pdc);
	}
}

void CMainWindow::OnOptionsSetParameters()
{
	// TODO: Add your command handler code here
	TRACE("OnOptionsSetParameters\n");
	SetComParameters setparams( this );
	setparams.m_Baudrate= " 9600";	
	setparams.m_Databits= "8";	
	setparams.m_Stopbits= "2";	
	setparams.m_Parity= "n";
	setparams.DoModal();           
	
	DCB dcb;
	char* chbuf=new char[200];
	sprintf(chbuf, "COM%d:%s,%s,%s,%s",m_CurrentComPort, (const char*)setparams.m_Baudrate, (const char*)setparams.m_Parity,
									    (const char*)setparams.m_Databits, (const char*)setparams.m_Stopbits );
	TRACE(chbuf);	
	TRACE("\n");                         			      
	BuildCommDCB(chbuf,&dcb);
	SetCommState(&dcb);
	
}
